#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n; 
    if (!(cin >> n)) 
        return 0;
    vector<long long> x(n), h(n);
    for (int i = 0; i < n; ++i) 
        cin >> x[i];
    for (int i = 0; i < n; ++i) 
        cin >> h[i];

    vector<long long> p2(max(0, n-1));
    for (int i = 0; i + 1 < n; ++i) {
        p2[i] = h[i] + x[i] - h[i+1] + x[i+1];
    }

    const long long INF2 = (1LL<<62); 
    vector<long long> best2(n, INF2);


    {
        vector<int> st;
        for (int i = 0; i < n; ++i) {
            while (!st.empty() && h[st.back()] < h[i]) st.pop_back();
            if (!st.empty()) {
                int j = st.back();
                best2[i] = min(best2[i], 2LL * llabs(x[i] - x[j]));
            }
            st.push_back(i);
        }
    }

    {
        vector<int> st;
        for (int i = n-1; i >= 0; --i) {
            while (!st.empty() && h[st.back()] < h[i]) st.pop_back();
            if (!st.empty()) {
                int j = st.back();
                best2[i] = min(best2[i], 2LL * llabs(x[i] - x[j]));
            }
            st.push_back(i);
        }
    }

    auto dist_to_interval2 = [&](long long xi2, long long L2, long long R2) -> long long {
        if (L2 > R2) return INF2; 
        if (xi2 < L2) return L2 - xi2;
        if (xi2 > R2) return xi2 - R2;
        return min(xi2 - L2, R2 - xi2);
    };

    for (int i = 0; i < n; ++i) {
        long long xi2 = 2LL * x[i];
        long long H = h[i];


        if (i - 1 >= 0) {
            int j = i - 1;
            if (H <= h[j]) {
                long long L2 = 2LL * x[j];
                long long R2 = min(p2[j], 2LL * x[j] + 2LL * (h[j] - H));
                best2[i] = min(best2[i], dist_to_interval2(xi2, L2, R2));
            }
        }

        
        if (i + 1 < n) {
            int j = i;
            if (H <= h[i+1]) {
                long long L2 = max(p2[j], 2LL * x[i+1] - 2LL * (h[i+1] - H));
                long long R2 = 2LL * x[i+1];
                best2[i] = min(best2[i], dist_to_interval2(xi2, L2, R2));
            }
        }
    }

    
    auto print_half = [&](long long d2) {
        if (d2 >= INF2/2) {
            cout << -1 << "\n";
            return;
        }
        if (d2 % 2 == 0) {
            cout << (d2 / 2) << "\n";
        } else {
            
            cout << (d2 / 2) << ".5\n";
        }
    };

    for (int i = 0; i < n; ++i) print_half(best2[i]);
    return 0;
}